
#include "CompleteSystem.h"
#include "H5Cpp.h"
#include <string>

int main(int argc, const char * argv[]) {
    
    //fixed system parameters
    constexpr int square_width=10;
    constexpr int square_hight=10;
    constexpr int critical_size=2;
    constexpr double decay_rate=0.0;
    constexpr long particles=50;
    
    //activation rate (sweep variable)
    double activation_rate=0.000001/1.5;
    
    //initiazation of the initial particle numbers
    std::array<std::array<long,square_width>,square_hight> monomers;
    std::array<std::array<long,square_width>,square_hight> inactive_monomers;
    for(auto& x: monomers){
        for(auto& y: x ){
            y=0;
        }
    }
    for(auto& x: inactive_monomers){
        for(auto& y: x ){
            y=particles;
        }
    }
    
    //vector containing results for all parameters sets
    std::vector<double> results;
    for (int i=0; i<10; ++i) {//sweep loop for different activation rate values
        
        //ensemble simulation
        double time=0;
        double yield=0;
        CompleteSystem<square_hight, square_width> test(inactive_monomers,monomers,critical_size,activation_rate,decay_rate,20);
        test.GetEnsAv(240, &time, &yield);
        
        //storage of all results
        results.push_back(double(square_width));
        results.push_back(double(square_hight));
        results.push_back(double(critical_size));
        results.push_back(double(inactive_monomers[0][0]));
        results.push_back(decay_rate);
        results.push_back(activation_rate);
        results.push_back(yield);
        results.push_back(time);
        //exponential increase of the activation rate
        activation_rate*=10;
    }
    //all resultsd are saved in an hdf5 file with the name "results"
    hsize_t dims[2];
    dims[0]=results.size()/8;
    dims[1]=8;
    H5::H5File file("results.hdf5",H5F_ACC_TRUNC);
    H5::DataSpace dataspace(2,dims);
    H5::DataSet dataset=file.createDataSet("summary", H5::PredType::NATIVE_DOUBLE, dataspace);
    dataset.write(results.data(), H5::PredType::NATIVE_DOUBLE);
    hsize_t dims2[1];
    dims2[0]=1;
    H5::DataSpace attr=H5::DataSpace(1,dims2);
    H5::Attribute attribute=dataset.createAttribute("Width",H5::PredType::NATIVE_INT,attr);
    attribute.write(H5::PredType::NATIVE_INT,&square_width);
    H5::Attribute attribute2=dataset.createAttribute("Hight",H5::PredType::NATIVE_INT,attr);
    attribute2.write(H5::PredType::NATIVE_INT,&square_hight);
    file.close();

    return 0;
}
